/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import mcinterface1201.ABuilderEntityBase;
import mcinterface1201.BuilderBlock;
import mcinterface1201.BuilderBlockTileEntity;
import mcinterface1201.BuilderEntityExisting;
import mcinterface1201.BuilderEntityLinkedSeat;
import mcinterface1201.BuilderEntityRenderForwarder;
import mcinterface1201.BuilderItem;
import mcinterface1201.BuilderTileEntity;
import mcinterface1201.BuilderTileEntityEnergyCharger;
import mcinterface1201.BuilderTileEntityFluidTank;
import mcinterface1201.BuilderTileEntityInventoryContainer;
import mcinterface1201.InterfaceClient;
import mcinterface1201.InterfaceCore;
import mcinterface1201.InterfaceEventsModelLoader;
import mcinterface1201.InterfaceInput;
import mcinterface1201.InterfacePacket;
import mcinterface1201.InterfaceRender;
import mcinterface1201.InterfaceSound;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mts")
public class InterfaceLoader {
    public static final String MODID = "mts";
    public static final String MODNAME = "Immersive Vehicles (MTS)";
    public static final String MODVER = "23.0.0";
    private final FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
    public static final Logger LOGGER = LogManager.getLogger((String)"mts");
    private final String gameDirectory = FMLPaths.GAMEDIR.get().toFile().getAbsolutePath();
    public static Set<String> packIDs = new HashSet<String>();
    private static List<BuilderBlock> normalBlocks = new ArrayList<BuilderBlock>();
    private static List<BuilderBlock> fluidBlocks = new ArrayList<BuilderBlock>();
    private static List<BuilderBlock> inventoryBlocks = new ArrayList<BuilderBlock>();
    private static List<BuilderBlock> chargerBlocks = new ArrayList<BuilderBlock>();
    protected static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"mts");

    public InterfaceLoader() {
        this.context.getModEventBus().addListener(this::init);
        this.context.getModEventBus().addListener(this::onPostConstruction);
    }

    public void init(FMLConstructModEvent event) {
        BuilderItem.ITEMS.register(this.context.getModEventBus());
        BuilderBlock.BLOCKS.register(this.context.getModEventBus());
        BuilderTileEntity.TILE_ENTITIES.register(this.context.getModEventBus());
        ABuilderEntityBase.ENTITIES.register(this.context.getModEventBus());
        CREATIVE_TABS.register(this.context.getModEventBus());
        boolean isClient = FMLEnvironment.dist.isClient();
        if (isClient) {
            new InterfaceManager(MODID, this.gameDirectory, new InterfaceCore(), new InterfacePacket(), new InterfaceClient(), new InterfaceInput(), new InterfaceSound(), new InterfaceRender());
            this.context.getModEventBus().addListener(InterfaceInput::onIVRegisterKeyMappingsEvent);
            this.context.getModEventBus().addListener(InterfaceRender::onIVRegisterShadersEvent);
            this.context.getModEventBus().addListener(InterfaceRender::onIVRegisterRenderersEvent);
        } else {
            new InterfaceManager(MODID, this.gameDirectory, new InterfaceCore(), new InterfacePacket(), null, null, null, null);
        }
        InterfaceManager.coreInterface.logError("Welcome to MTS VERSION: 23.0.0");
        ConfigSystem.loadFromDisk(isClient);
        ArrayList<File> packDirectories = new ArrayList<File>();
        File modDirectory = new File(this.gameDirectory, "mods");
        if (modDirectory.exists()) {
            packDirectories.add(modDirectory);
        }
        try {
            modDirectory = ModList.get().getModFileById(MODID).getFile().getFilePath().getParent().toFile().getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (modDirectory.exists()) {
            packDirectories.add(modDirectory);
        }
        if (!packDirectories.isEmpty()) {
            PackParser.addDefaultItems();
            PackParser.parsePacks(packDirectories);
        } else {
            InterfaceManager.coreInterface.logError("Could not find mods directory!  Checked game directory: " + this.gameDirectory + " and runtime file directory:" + modDirectory);
        }
        packIDs.addAll(PackParser.getAllPackIDs());
        HashSet<ABlockBase> blocksRegistred = new HashSet<ABlockBase>();
        HashMap<String, List> creativeTabsRequired = new HashMap<String, List>();
        for (String packID : PackParser.getAllPackIDs()) {
            for (AItemPack<?> item : PackParser.getAllItemsForPack(packID, true)) {
                IItemBlock itemBlock;
                ABlockBase itemBlockBlock;
                if (item.autoGenerate()) {
                    boolean hideOnCreativeTab;
                    BuilderItem.ITEMS.register(item.getRegistrationName(), () -> {
                        Item.Properties itemProperties = new Item.Properties();
                        itemProperties.m_41487_(item.getStackSize());
                        if (item instanceof ItemItem && ((JSONItem)((ItemItem)item).definition).food != null) {
                            IItemFood food = (IItemFood)((Object)item);
                            itemProperties.m_41489_(new FoodProperties.Builder().m_38760_(food.getHungerAmount()).m_38758_(food.getSaturationAmount()).m_38767_());
                        }
                        return new BuilderItem(itemProperties, item);
                    });
                    boolean bl = hideOnCreativeTab = ((AJSONItem)item.definition).general.hideOnCreativeTab || item instanceof AItemSubTyped && ((AItemSubTyped)item).subDefinition.hideOnCreativeTab;
                    if (!(hideOnCreativeTab || ((AJSONItem)item.definition).packID.equals(MODID) && ((AJSONItem)item.definition).systemName.contains("invisible"))) {
                        creativeTabsRequired.computeIfAbsent(item.getCreativeTabID(), k -> new ArrayList()).add(item);
                    }
                }
                if (!(item instanceof IItemBlock) || blocksRegistred.contains(itemBlockBlock = (itemBlock = (IItemBlock)((Object)item)).getBlock())) continue;
                String name = itemBlock.getBlockClass() != null ? itemBlock.getBlockClass().getSimpleName().substring("Block".length()).toLowerCase(Locale.ROOT) : (item.getRegistrationName() + "_Block").toLowerCase(Locale.ROOT);
                blocksRegistred.add(itemBlockBlock);
                BuilderBlock.BLOCKS.register(name, () -> {
                    BuilderBlock wrapper;
                    if (itemBlockBlock instanceof ABlockBaseTileEntity) {
                        wrapper = new BuilderBlockTileEntity(itemBlockBlock);
                        if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)itemBlockBlock).getTileEntityClass())) {
                            fluidBlocks.add(wrapper);
                        } else if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)itemBlockBlock).getTileEntityClass())) {
                            inventoryBlocks.add(wrapper);
                        } else if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)itemBlockBlock).getTileEntityClass())) {
                            chargerBlocks.add(wrapper);
                        } else {
                            normalBlocks.add(wrapper);
                        }
                    } else {
                        wrapper = new BuilderBlock(itemBlockBlock);
                    }
                    BuilderBlock.blockMap.put(itemBlockBlock, wrapper);
                    return wrapper;
                });
            }
        }
        creativeTabsRequired.forEach((tabID, tabItems) -> CREATIVE_TABS.register(tabID, () -> {
            JSONPack packConfiguration = PackParser.getPackConfiguration(tabID);
            Object tabIconItem = packConfiguration.packItem != null ? PackParser.getItem(packConfiguration.packID, packConfiguration.packItem) : null;
            ItemStack tabIconStack = tabIconItem != null ? new ItemStack((ItemLike)BuilderItem.itemMap.get(tabIconItem)) : null;
            CreativeModeTab.DisplayItemsGenerator validItemsGenerator = (pParameters, pOutput) -> tabItems.forEach(tabItem -> pOutput.m_246326_((ItemLike)BuilderItem.itemMap.get(tabItem)));
            Supplier<ItemStack> iconSupplier = tabIconStack != null ? () -> tabIconStack : () -> new ItemStack((ItemLike)BuilderItem.itemMap.get(tabItems.get((int)(System.currentTimeMillis() / 1000L % (long)tabItems.size()))));
            return CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)packConfiguration.packName)).m_257737_(iconSupplier).m_257501_(validItemsGenerator).m_257652_();
        }));
        for (int i = 0; i < BlockCollision.blockInstances.size(); ++i) {
            BlockCollision collisionBlock = BlockCollision.blockInstances.get(i);
            String name = collisionBlock.getClass().getSimpleName().substring("Block".length()).toLowerCase(Locale.ROOT) + i;
            BuilderBlock.BLOCKS.register(name, () -> {
                BuilderBlock wrapper = new BuilderBlock(collisionBlock);
                BuilderBlock.blockMap.put(collisionBlock, wrapper);
                return wrapper;
            });
        }
        if (isClient) {
            InterfaceEventsModelLoader.init();
        }
        LanguageSystem.init(isClient);
        BuilderTileEntity.TE_TYPE = BuilderTileEntity.TILE_ENTITIES.register("builder_base", () -> BlockEntityType.Builder.m_155273_(BuilderTileEntity::new, (Block[])normalBlocks.toArray(new BuilderBlock[0])).m_58966_(null));
        BuilderTileEntityFluidTank.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_fluidtank", () -> BlockEntityType.Builder.m_155273_(BuilderTileEntityFluidTank::new, (Block[])fluidBlocks.toArray(new BuilderBlock[0])).m_58966_(null));
        BuilderTileEntityInventoryContainer.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_inventory", () -> BlockEntityType.Builder.m_155273_(BuilderTileEntityInventoryContainer::new, (Block[])inventoryBlocks.toArray(new BuilderBlock[0])).m_58966_(null));
        BuilderTileEntityEnergyCharger.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_charger", () -> BlockEntityType.Builder.m_155273_(BuilderTileEntityEnergyCharger::new, (Block[])chargerBlocks.toArray(new BuilderBlock[0])).m_58966_(null));
        BuilderEntityExisting.E_TYPE2 = ABuilderEntityBase.ENTITIES.register("builder_existing", () -> EntityType.Builder.m_20704_(BuilderEntityExisting::new, (MobCategory)MobCategory.MISC).m_20699_(0.05f, 0.05f).m_20702_(512).m_20717_(5).m_20712_("builder_existing"));
        BuilderEntityLinkedSeat.E_TYPE3 = ABuilderEntityBase.ENTITIES.register("builder_seat", () -> EntityType.Builder.m_20704_(BuilderEntityLinkedSeat::new, (MobCategory)MobCategory.MISC).m_20699_(0.05f, 0.05f).m_20702_(512).m_20717_(5).m_20712_("builder_seat"));
        BuilderEntityRenderForwarder.E_TYPE4 = ABuilderEntityBase.ENTITIES.register("builder_rendering", () -> EntityType.Builder.m_20704_(BuilderEntityRenderForwarder::new, (MobCategory)MobCategory.MISC).m_20699_(0.05f, 0.05f).m_20702_(512).m_20717_(5).m_20712_("builder_rendering"));
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof IItemEntityProvider)) continue;
            ((IItemEntityProvider)((Object)packItem)).registerEntities(BuilderEntityExisting.entityMap);
        }
        InterfacePacket.init();
        if (isClient) {
            InterfaceManager.inputInterface.initConfigKey();
            ConfigSystem.saveToDisk();
        }
    }

    public void onPostConstruction(FMLLoadCompleteEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            ConfigSystem.settings.fuel.lastLoadedFluids = InterfaceManager.clientInterface.getAllFluidNames();
            ConfigSystem.saveToDisk();
        }
    }
}

